const _Dict = new class _Dict extends _DictUtil {
    constructor() {
        super();

        this.dictUrl = "/admin/dict/";
        this.data = {
            site_domain_type: [
                {id: 0, name: format.success('子域名')},
                {id: 1, name: format.danger('私有域名')}
            ],
            manage_status: [
                {id: 0, name: format.danger("冻结")},
                {id: 1, name: format.success('正常')}
            ],
            manage_log_risk: [
                {id: 0, name: format.success('无风险')},
                {id: 1, name: format.warning('一般风险')},
                {id: 2, name: format.danger('高危风险')}
            ],
            repertory_category_status: [
                {id: 1, name: format.success('已启用')},
                {id: 0, name: format.danger('未启用')},
            ],
            repertory_item_status: [
                {id: 0, name: format.danger('暂未入库')},
                {id: 1, name: format.warning('未上架')},
                {id: 2, name: format.success('已上架')},
                {id: 3, name: format.dark('已封禁')},
            ],
            repertory_item_direct_status: [
                {id: 0, name: format.danger('未接入')},
                {id: 1, name: format.success('已经接入')},
            ],
            repertory_order_status: [
                {id: 0, name: format.danger('等待发货')},
                {id: 1, name: format.success('已发货')},
                {id: 2, name: format.dark('发货失败')},
                {id: 3, name: format.cambridgeBlue('已退款')},
            ],
            repertory_item_type: [
                {id: 0, name: format.danger('虚拟卡密')},
                {id: 1, name: format.success('手动发货')},
                {id: 2, name: format.warning('插件发货')},
            ],
            repertory_item_privacy: [
                {id: 0, name: format.color('绝对私密' , "red")},
                {id: 1, name: format.color('开放对接码' , "blue")},
                {id: 2, name: format.color('全网开放' , "green")},
            ],
            repertory_item_refund_mode: [
                {id: 0, name: format.danger('不支持退款')},
                {id: 1, name: format.primary('有条件退款')},
                {id: 2, name: format.success('无理由退款')},
            ],
            repertory_item_card_take_priority: [
                {id: 0, name: "旧卡优先"},
                {id: 1, name: "随机取卡"},
                {id: 2, name: "新卡优先"},
            ],
            repertory_item_sku_user_status: [
                {id: 0, name: "未启用"},
                {id: 1, name: "已生效"}
            ],
            shop_category_status: [
                {id: 0, name: format.danger('未启用')},
                {id: 1, name: format.success('已启用')}
            ],
            shop_category_user_type: [
                {id: 0, name: format.danger('直营店')},
                {id: 1, name: format.success('商户')}
            ],
            shop_item_status: [
                {id: 0, name: format.danger('未上架')},
                {id: 1, name: format.success('已上架')}
            ],
            shop_order_status: [
                {id: 0, name: format.danger(util.icon("icon-yijujue") + ' 未付款')},
                {id: 1, name: format.success(util.icon("icon-chenggong") + ' 已付款')},
                {id: 2, name: format.dark(util.icon("icon-guanbi") + ' 已取消')},
                {id: 3, name: format.warning(util.icon("icon-dengdai") + ' 正在付款')}
            ],
            pay_order_status: [
                {id: 0, name: format.danger(util.icon("icon-yijujue") + ' 未支付')},
                {id: 1, name: format.warning(util.icon("icon-dengdai") + ' 正在支付')},
                {id: 2, name: format.success(util.icon("icon-chenggong") + ' 已支付')},
                {id: 3, name: format.dark(util.icon("icon-guanbi") + ' 支付关闭')}
            ],
            shop_order_type: [
                /*  {id: 0, name: format.color('商品订单', "#5a83e8")},*/
                {id: 1, name: format.color('充值订单', "#0bc81a")},
                {id: 2, name: format.color('升级用户组', "#bcdc33")},
                {id: 3, name: format.color('升级会员等级', "#b357f1")},
                {id: 49, name: format.color('第三方', "#f66969")},
            ],
            shop_order_item_status: [
                {id: 0, name: format.danger(util.icon("icon-fahuozhong") + ' 等待发货')},
                {id: 1, name: format.success(util.icon("icon-shalou") + ' 已发货')},
                {id: 2, name: format.dark(util.icon("icon-guanbi") + ' 发货异常')},
                {id: 3, name: format.success(util.icon("icon-chenggong") + ' 已收货')},
                {id: 4, name: format.warning(util.icon("icon-dengdai") + ' 正在维权')},
                {id: 5, name: format.primary(util.icon("icon-yituikuan") + ' 已退款')},
                {id: 6, name: format.dark(util.icon("icon-guanbi") + ' 平台发货失败')},
            ],
            item_refund_mode: [
                {id: 0, name: format.color('不支持退款', "red")},
                {id: 1, name: format.color('有条件退款', "bule")},
                {id: 2, name: format.color('无理由退款', "green")}
            ],
            markup_mode: [
                {id: 0, name: format.danger('自定义配置')},
                {id: 1, name: format.success('模板配置')}
            ],
            markup_type: [
                {id: 0, name: format.success('比例向上浮动')},
                {id: 1, name: format.success('固定金额向上浮动')},
                {id: 2, name: format.danger('比例向下浮动')},
                {id: 3, name: format.danger('固定金额向下浮动')}
            ],
            plugin_status: [
                {id: 0, name: format.danger(util.icon("icon-tingzhi") + ' Stop')},
                {id: 1, name: format.success(util.icon('icon-yunhangzhong3') + ' Running')},
                {id: 2, name: format.warning(util.icon('icon-dengdai1') + ' Starting')},
                {id: 3, name: format.warning(util.icon('icon-dengdai1') + ' Stopping')},
            ],
            plugin_type: [
                {id: 1, name: "General"},
                {id: 2, name: "支付接口"},
                {id: 4, name: "货源接入"},
                {id: 8, name: "主题美化"},
            ],
            pay_equipment: [
                {id: 0, name: format.info(util.icon('icon-shangyehuaquanqiu') + " " + "通用")},
                {id: 1, name: format.success(util.icon('icon-shouji3') + " " + "手机")},
                {id: 2, name: format.cambridgeBlue(util.icon('icon-diannao') + " " + "电脑")},
                {id: 3, name: format.success(util.icon('icon-weixin') + " " + "微信")}
            ],
            pay_scope: [
                {id: "product", name: "购物"},
                {id: "recharge", name: "充值"},
                {id: "plugin", name: "插件"},
                {id: "level", name: "等级"},
                {id: "group", name: "用户组"},
            ],
            order_report_status: [
                {id: 0, name: format.color('等待处理', "red")},
                {id: 1, name: format.color('商家处理中', "#efd73d")},
                {id: 2, name: format.color('顾客处理中', "#3e5df5")},
                {id: 3, name: format.color('处理完成', "#0bc81a")}
            ],
            order_report_expect: [
                {id: 0, name: "更换/补发商品"},
                {id: 1, name: "申请退款"},
                {id: 2, name: "假一赔三"}
            ],
            order_report_handle_type: [
                {id: 0, name: "交涉中"},
                {id: 1, name: "更换/补发商品"},
                {id: 2, name: "退还部分费用"},
                {id: 3, name: "全额退款"},
                {id: 4, name: "已撤诉"}
            ],
            order_report_type: [
                {id: 0, name: "无法使用(虚拟商品)"},
                {id: 1, name: "大小/尺寸与商品描述不符"},
                {id: 2, name: "颜色/图案/款式与商品描述不符"},
                {id: 3, name: "材质与商品描述不符"},
                {id: 4, name: "生产日期/保质期与商品描述不符"},
                {id: 5, name: "做工粗糙/有瑕疵"},
                {id: 6, name: "少件/漏发"},
                {id: 7, name: "包装/商品破损/污渍/裂痕/变形"},
                {id: 8, name: "假冒品牌"},
                {id: 9, name: "质量问题"},
                {id: 10, name: "未收到商品"},
                {id: 11, name: "卖家发错货"}
            ],
            user_bill_type: [
                {id: 9, name: "充值"},
                {id: 0, name: "进货"},
                {id: 1, name: "供货结算"},
                {id: 2, name: "下级分红"},
                {id: 3, name: "订单分红"},
                {id: 4, name: "购物"},
                {id: 5, name: "订单退款"},
                {id: 6, name: "支付退款"},
                {id: 8, name: "转账"},
                {id: 11, name: "提现"},
                {id: 12, name: "提现驳回"},
                {id: 13, name: "押金"},
                {id: 10, name: "推广分红"},
                {id: 7, name: "人工操作"},
                {id: 14, name: "商品出售"},
                {id: 15, name: "借款"},
                {id: 16, name: "还款"},
                {id: 17, name: "拨款"}
            ],
            user_bill_status: [
                {id: 0, name: format.success(util.icon("icon-chenggong") + " 已完成")},
                {id: 1, name: format.warning(util.icon("icon-tishi") + ' 平台冻结中')},
                {id: 2, name: format.danger(util.icon('icon-cuowu') + ' 已回滚')}
            ],
            user_bill_action: [
                {id: 0, name: format.color('支出', "#da3030")},
                {id: 1, name: format.color('收入', "#0bc81a")}
            ],
            user_bill_is_withdraw: [
                {id: 0, name: format.danger(util.icon('icon-cuowu'))},
                {id: 1, name: format.success(util.icon("icon-chenggong"))}
            ],
            user_identity_type: [
                {id: 0, name: "中国居民身份证"},
                {id: 1, name: "香港永久居民身份证"},
                {id: 2, name: "澳门永久性居民身份证"},
                {id: 3, name: "国际护照"}
            ],
            user_identity_status: [
                {id: 0, name: format.warning(util.icon("icon-tishi") + ' 审核中')},
                {id: 1, name: format.success(util.icon("icon-chenggong") + " 实名成功")},
                {id: 2, name: format.danger(util.icon('icon-cuowu') + ' 实名失败')}
            ],
            user_bank_card_status: [
                {id: 0, name: format.warning(util.icon("icon-tishi") + ' 银行卡异常')},
                {id: 1, name: format.success(util.icon("icon-chenggong") + " 正常使用")}
            ],
            user_withdraw_status: [
                {id: 0, name: format.warning(util.icon("icon-tishi") + ' 等待处理')},
                {id: 1, name: format.success(util.icon("icon-chenggong") + " 已处理")},
                {id: 2, name: format.danger(util.icon('icon-cuowu') + ' 已驳回')}
            ],
            order_summary_date_type: [
                {id: 0, name: "按天汇总"},
                {id: 1, name: "按周汇总"},
                {id: 2, name: "按月汇总"},
                {id: 3, name: "按年汇总"}
            ],
            manage_login_log_dangerous_level: [
                {id: 0, name: "无风险"},
                {id: 1, name: "高危"}
            ],
            upload_file_type: [
                {id: "image", name: "图片"},
                {id: "video", name: "视频"},
                {id: "doc", name: "文档"},
                {id: "other", name: "其他"},
            ],
            manage_login_log_dangerous: [
                {id: 0, name: format.success(util.icon("icon-chenggong") + " 安全")},
                {id: 1, name: format.danger(util.icon('icon-cuowu') + ' 高危，建议立即修改密码')}
            ],
            store_plugin_type: [
                {id: 49, name: "已购买"},
                {id: 0, name: format.primary(util.icon("icon-plugin-general") + " 通用插件")},
                {id: 1, name: format.success(util.icon("icon-plugin-pay") + " 支付插件")},
                {id: 2, name: format.warning(util.icon("icon-plugin-ship") + " 货源插件")},
                {id: 3, name: format.danger(util.icon("icon-plugin-theme") + " 主题模板")},
            ],
            developer_plugin_type: [
                {id: 0, name: format.primary(util.icon("icon-plugin-general") + " 通用插件")},
                {id: 1, name: format.success(util.icon("icon-plugin-pay") + " 支付插件")},
                {id: 2, name: format.warning(util.icon("icon-plugin-ship") + " 货源插件")},
                {id: 3, name: format.danger(util.icon("icon-plugin-theme") + " 主题模板")},
            ],
            developer_plugin_status: [
                {id: 0, name: format.primary(util.icon("icon-kaifazhe") + ' 开发中')},
                {id: 1, name: format.success(util.icon("icon-chenggong") + ' 已上架')},
                {id: 2, name: format.danger(util.icon("icon-yijujue") + ' 停机维护中')},
                {id: 3, name: format.warning(util.icon("icon-dengdai") + ' 不停机维护中')},
                {id: 49, name: format.warning(util.icon("icon-dengdai") + ' 审核中')},
                {id: 50, name: format.dark(util.icon("icon-guanbi") + ' 审核不通过')},

            ],
            permission_type: [
                {id: 0, name: "引导菜单"},
                {id: 1, name: "菜单(页面)"},
                {id: 2, name: "API"},
                {id: 3, name: "按钮"}
            ],
            store_subscription: [
                {id: 'monthly_fee', name: "1个月"},
                {id: 'quarterly_fee', name: "3个月"},
                {id: 'half_yearly_fee', name: "6个月"},
                {id: 'yearly_fee', name: "1年"},
                {id: 'permanent_fee', name: "永久"}
            ],
            store_renewal_subscription: [
                {id: 0, name: "按月"},
                {id: 1, name: "每三个月"},
                {id: 2, name: "每半年"},
                {id: 3, name: "每年"},
                {id: 4, name: "终身使用"}
            ],
            sms_country: [
                {id: "86", name: "中国"},
                {id: "852", name: "香港"},
                {id: "1", name: "美国"},
                {id: "81", name: "日本"},
                {id: "886", name: "台湾"},
                {id: "93", name: "阿富汗"},
                {id: "355", name: "阿尔巴尼亚"},
                {id: "213", name: "阿尔及利亚"},
                {id: "376", name: "安道尔"},
                {id: "244", name: "安哥拉"},
                {id: "672", name: "南极洲"},
                {id: "54", name: "阿根廷"},
                {id: "374", name: "亚美尼亚"},
                {id: "297", name: "阿鲁巴"},
                {id: "61", name: "澳大利亚"},
                {id: "43", name: "奥地利"},
                {id: "994", name: "阿塞拜疆"},
                {id: "973", name: "巴林"},
                {id: "880", name: "孟加拉国"},
                {id: "375", name: "白俄罗斯"},
                {id: "32", name: "比利时"},
                {id: "501", name: "伯利兹"},
                {id: "229", name: "贝宁"},
                {id: "975", name: "不丹"},
                {id: "591", name: "玻利维亚"},
                {id: "387", name: "波斯尼亚和黑塞哥维那"},
                {id: "267", name: "博茨瓦纳"},
                {id: "55", name: "巴西"},
                {id: "246", name: "英属印度洋领地"},
                {id: "673", name: "文莱"},
                {id: "359", name: "保加利亚"},
                {id: "226", name: "布基纳法索"},
                {id: "257", name: "布隆迪"},
                {id: "855", name: "柬埔寨"},
                {id: "237", name: "喀麦隆"},
                {id: "1", name: "加拿大"},
                {id: "238", name: "佛得角"},
                {id: "236", name: "中非共和国"},
                {id: "235", name: "乍得"},
                {id: "56", name: "智利"},
                {id: "57", name: "哥伦比亚"},
                {id: "269", name: "科摩罗"},
                {id: "242", name: "刚果共和国"},
                {id: "243", name: "刚果民主共和国"},
                {id: "682", name: "库克群岛"},
                {id: "506", name: "哥斯达黎加"},
                {id: "385", name: "克罗地亚"},
                {id: "53", name: "古巴"},
                {id: "357", name: "塞浦路斯"},
                {id: "420", name: "捷克"},
                {id: "45", name: "丹麦"},
                {id: "253", name: "吉布提"},
                {id: "670", name: "东帝汶"},
                {id: "593", name: "厄瓜多尔"},
                {id: "20", name: "埃及"},
                {id: "503", name: "萨尔瓦多"},
                {id: "240", name: "赤道几内亚"},
                {id: "291", name: "厄立特里亚"},
                {id: "372", name: "爱沙尼亚"},
                {id: "251", name: "埃塞俄比亚"},
                {id: "500", name: "福克兰群岛"},
                {id: "298", name: "法罗群岛"},
                {id: "679", name: "斐济"},
                {id: "358", name: "芬兰"},
                {id: "33", name: "法国"},
                {id: "594", name: "法属圭亚那"},
                {id: "689", name: "法属波利尼西亚"},
                {id: "241", name: "加蓬"},
                {id: "220", name: "冈比亚"},
                {id: "995", name: "格鲁吉亚"},
                {id: "49", name: "德国"},
                {id: "233", name: "加纳"},
                {id: "350", name: "直布罗陀"},
                {id: "30", name: "希腊"},
                {id: "299", name: "格陵兰"},
                {id: "502", name: "危地马拉"},
                {id: "224", name: "几内亚"},
                {id: "245", name: "几内亚比绍"},
                {id: "592", name: "圭亚那"},
                {id: "509", name: "海地"},
                {id: "504", name: "洪都拉斯"},
                {id: "36", name: "匈牙利"},
                {id: "354", name: "冰岛"},
                {id: "91", name: "印度"},
                {id: "62", name: "印度尼西亚"},
                {id: "98", name: "伊朗"},
                {id: "964", name: "伊拉克"},
                {id: "353", name: "爱尔兰"},
                {id: "972", name: "以色列"},
                {id: "39", name: "意大利"},
                {id: "225", name: "科特迪瓦"},
                {id: "962", name: "约旦"},
                {id: "7", name: "哈萨克斯坦"},
                {id: "254", name: "肯尼亚"},
                {id: "686", name: "基里巴斯"},
                {id: "965", name: "科威特"},
                {id: "996", name: "吉尔吉斯斯坦"},
                {id: "856", name: "老挝"},
                {id: "371", name: "拉脱维亚"},
                {id: "961", name: "黎巴嫩"},
                {id: "266", name: "莱索托"},
                {id: "231", name: "利比里亚"},
                {id: "218", name: "利比亚"},
                {id: "423", name: "列支敦士登"},
                {id: "370", name: "立陶宛"},
                {id: "352", name: "卢森堡"},
                {id: "853", name: "澳门"},
                {id: "389", name: "北马其顿"},
                {id: "261", name: "马达加斯加"},
                {id: "265", name: "马拉维"},
                {id: "60", name: "马来西亚"},
                {id: "960", name: "马尔代夫"},
                {id: "223", name: "马里"},
                {id: "356", name: "马耳他"},
                {id: "692", name: "马绍尔群岛"},
                {id: "222", name: "毛里塔尼亚"},
                {id: "230", name: "毛里求斯"},
                {id: "52", name: "墨西哥"},
                {id: "691", name: "密克罗尼西亚"},
                {id: "373", name: "摩尔多瓦"},
                {id: "377", name: "摩纳哥"},
                {id: "976", name: "蒙古"},
                {id: "382", name: "黑山"},
                {id: "212", name: "摩洛哥"},
                {id: "258", name: "莫桑比克"},
                {id: "95", name: "缅甸"},
                {id: "264", name: "纳米比亚"},
                {id: "674", name: "瑙鲁"},
                {id: "977", name: "尼泊尔"},
                {id: "31", name: "荷兰"},
                {id: "64", name: "新西兰"},
                {id: "505", name: "尼加拉瓜"},
                {id: "227", name: "尼日尔"},
                {id: "234", name: "尼日利亚"},
                {id: "850", name: "朝鲜"},
                {id: "47", name: "挪威"},
                {id: "968", name: "阿曼"},
                {id: "92", name: "巴基斯坦"},
                {id: "680", name: "帕劳"},
                {id: "970", name: "巴勒斯坦"},
                {id: "507", name: "巴拿马"},
                {id: "675", name: "巴布亚新几内亚"},
                {id: "595", name: "巴拉圭"},
                {id: "51", name: "秘鲁"},
                {id: "63", name: "菲律宾"},
                {id: "48", name: "波兰"},
                {id: "351", name: "葡萄牙"},
                {id: "974", name: "卡塔尔"},
                {id: "40", name: "罗马尼亚"},
                {id: "7", name: "俄罗斯"},
                {id: "250", name: "卢旺达"},
                {id: "290", name: "圣赫勒拿"},
                {id: "1869", name: "圣基茨和尼维斯"},
                {id: "1758", name: "圣卢西亚"},
                {id: "1784", name: "圣文森特和格林纳丁斯"},
                {id: "685", name: "萨摩亚"},
                {id: "378", name: "圣马力诺"},
                {id: "239", name: "圣多美和普林西比"},
                {id: "966", name: "沙特阿拉伯"},
                {id: "221", name: "塞内加尔"},
                {id: "381", name: "塞尔维亚"},
                {id: "248", name: "塞舌尔"},
                {id: "232", name: "塞拉利昂"},
                {id: "65", name: "新加坡"},
                {id: "421", name: "斯洛伐克"},
                {id: "386", name: "斯洛文尼亚"},
                {id: "677", name: "所罗门群岛"},
                {id: "252", name: "索马里"},
                {id: "27", name: "南非"},
                {id: "82", name: "韩国"},
                {id: "34", name: "西班牙"},
                {id: "94", name: "斯里兰卡"},
                {id: "249", name: "苏丹"},
                {id: "597", name: "苏里南"},
                {id: "268", name: "斯威士兰"},
                {id: "46", name: "瑞典"},
                {id: "41", name: "瑞士"},
                {id: "963", name: "叙利亚"},
                {id: "992", name: "塔吉克斯坦"},
                {id: "255", name: "坦桑尼亚"},
                {id: "66", name: "泰国"},
                {id: "670", name: "东帝汶"},
                {id: "228", name: "多哥"},
                {id: "690", name: "托克劳"},
                {id: "676", name: "汤加"},
                {id: "1868", name: "特立尼达和多巴哥"},
                {id: "216", name: "突尼斯"},
                {id: "90", name: "土耳其"},
                {id: "993", name: "土库曼斯坦"},
                {id: "688", name: "图瓦卢"},
                {id: "256", name: "乌干达"},
                {id: "380", name: "乌克兰"},
                {id: "971", name: "阿联酋"},
                {id: "44", name: "英国"},
                {id: "598", name: "乌拉圭"},
                {id: "998", name: "乌兹别克斯坦"},
                {id: "678", name: "瓦努阿图"},
                {id: "379", name: "梵蒂冈"},
                {id: "58", name: "委内瑞拉"},
                {id: "84", name: "越南"},
                {id: "681", name: "瓦利斯和富图纳"},
                {id: "212", name: "西撒哈拉"},
                {id: "967", name: "也门"},
                {id: "260", name: "赞比亚"},
                {id: "263", name: "津巴布韦"}
            ]
        };
    }
}