<?php

declare(strict_types=1);
/**
 * This file is part of Hyperf.
 *
 * @link     https://www.hyperf.io
 * @document https://hyperf.wiki
 * @contact  group@hyperf.io
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */

namespace Hyperf\Engine\Http\V2;

use Hyperf\Engine\Contract\Http\V2\RequestInterface;

class Request implements RequestInterface
{
    public function __construct(protected string $path = '/', protected string $method = 'GET', protected string $body = '', protected array $headers = [], protected bool $pipeline = false)
    {
    }

    public function getPath(): string
    {
        return $this->path;
    }

    public function setPath(string $path): void
    {
        $this->path = $path;
    }

    public function getMethod(): string
    {
        return $this->method;
    }

    public function setMethod(string $method): void
    {
        $this->method = $method;
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public function setBody(string $body): void
    {
        $this->body = $body;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    public function setHeaders(array $headers): void
    {
        $this->headers = $headers;
    }

    public function isPipeline(): bool
    {
        return $this->pipeline;
    }

    public function setPipeline(bool $pipeline): void
    {
        $this->pipeline = $pipeline;
    }
}
